/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE */;
/*!40101 SET SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES */;
/*!40103 SET SQL_NOTES='ON' */;


DROP DATABASE IF EXISTS `pos_blank2223`;
CREATE DATABASE `pos_blank2223` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `pos_blank2223`;
CREATE TABLE `acctdet` (
  `adID` bigint(10) NOT NULL AUTO_INCREMENT,
  `ACCTCODE` varchar(6) DEFAULT NULL,
  `ACCTNAME` varchar(50) DEFAULT NULL,
  `ADDRESS1` varchar(30) DEFAULT '',
  `ADDRESS2` varchar(60) DEFAULT '',
  `MOB1` varchar(15) DEFAULT '',
  `MOB2` varchar(15) DEFAULT '',
  `EMAIL` varchar(50) DEFAULT '',
  `CONTPERSON` varchar(30) DEFAULT '',
  `GSTIN` varchar(30) DEFAULT '-',
  `CREDITLIMIT` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`adID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
CREATE TABLE `acctinf` (
  `ACCTCODE` varchar(8) NOT NULL DEFAULT '-',
  `ACCTNAME` varchar(50) DEFAULT '-',
  `GRCODE` char(3) DEFAULT '-',
  `GRNAME` varchar(30) DEFAULT '-',
  `OPBALDR` decimal(10,2) DEFAULT '0.00',
  `OPBALCR` decimal(10,2) DEFAULT '0.00',
  `OPBALDR2` double(10,2) DEFAULT '0.00',
  `OPBALCR2` double(10,2) DEFAULT '0.00',
  `TRANDR` decimal(10,2) DEFAULT '0.00',
  `TRANCR` decimal(10,2) DEFAULT '0.00',
  `TRANDR2` decimal(10,2) DEFAULT '0.00',
  `TRANCR2` decimal(10,2) DEFAULT '0.00',
  `LOCKED` int(3) DEFAULT '0',
  `ISPRIMARY` int(3) DEFAULT '0',
  `LOCID` int(3) DEFAULT '0',
  `OBFIXED` int(3) DEFAULT '0',
  `OB2FIXED` int(3) DEFAULT '0',
  PRIMARY KEY (`ACCTCODE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `acctinf` VALUES ('A00001','CAPITAL A/C','A','CAPITAL ACCOUNTS',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('O00001','DISCOUNT GIVEN','O','OTHER EXPENSES',0.25,0,0,0,0,0,0,0,1,1,2,0,0);
INSERT INTO `acctinf` VALUES ('O00002','SALES COMMISSION','O','OTHER EXPENSES',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('Q00001','DISCOUNT RECEIPT','Q','COMMISSION EARNED/RECEIPTS',0,3595.8,0,0,0,0,0,20,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('R00001','PURCHASE A/C','R','PURCHASE ACCOUNTS',23540060.7,0,0,0,9350,0,3925,0,1,1,2,0,0);
INSERT INTO `acctinf` VALUES ('S00001','SALES A/C','S','SALES ACCOUNTS',0,37656.53,0,0,203.4,1672.4,218.7,1220.7,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00001','SERVICE CHARGE PAID','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00002','SERVICE CHARGE RECEIVED','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,2,0,0);
INSERT INTO `acctinf` VALUES ('V00003','CGST INPUT','V','DUTIES & TAXES',2101246.84,0,0,0,729,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00004','SGST INPUT','V','DUTIES & TAXES',2101246.84,0,0,0,729,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00005','IGST INPUT','V','DUTIES & TAXES',0,0,0,0,216,203.4,0,218.7,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00006','CGST OUTPUT','V','DUTIES & TAXES',0,3557.69,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00007','SGST OUTPUT','V','DUTIES & TAXES',0,3557.69,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('V00008','IGST OUTPUT','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('W00001','SALES RETURN','W','RETURN INWARD',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('W00002','CREDIT NOTE','W','RETURN INWARD',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('X00001','PURCHASE RETURN','X','RETURN OUTWARD',0,0,0,0,0,0,0,0,1,1,0,0,0);
INSERT INTO `acctinf` VALUES ('X00002','DEBIT NOTE','X','RETURN OUTWARD',0,0,0,0,0,0,0,0,1,1,0,0,0);
CREATE TABLE `groupinf` (
  `GrCode` char(1) DEFAULT NULL,
  `GrName` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `groupinf` VALUES ('Z','TRADING PRODUCTS (STOCK)');
INSERT INTO `groupinf` VALUES ('Y','DEPRECIATION');
INSERT INTO `groupinf` VALUES ('X','RETURN OUTWARD');
INSERT INTO `groupinf` VALUES ('W','RETURN INWARD');
INSERT INTO `groupinf` VALUES ('V','DUTIES & TAXES');
INSERT INTO `groupinf` VALUES ('U','TRADING INCOMES');
INSERT INTO `groupinf` VALUES ('T','TRADING EXPENSES');
INSERT INTO `groupinf` VALUES ('S','SALES ACCOUNTS');
INSERT INTO `groupinf` VALUES ('R','PURCHASE ACCOUNTS');
INSERT INTO `groupinf` VALUES ('Q','COMMISSION EARNED/RECEIPTS');
INSERT INTO `groupinf` VALUES ('P','MISC. INCOME/RECEIPTS');
INSERT INTO `groupinf` VALUES ('O','OTHER EXPENSES');
INSERT INTO `groupinf` VALUES ('N','ESTABLISHMENT EXPENSES');
INSERT INTO `groupinf` VALUES ('M','SECURITY/ADVANCES GIVEN');
INSERT INTO `groupinf` VALUES ('L','BAD DEBTS');
INSERT INTO `groupinf` VALUES ('K','SUNDRY DEBTORS');
INSERT INTO `groupinf` VALUES ('J','BANK ACCOUNT');
INSERT INTO `groupinf` VALUES ('I','CASH ACCOUNT');
INSERT INTO `groupinf` VALUES ('H','FIXED ASSETS');
INSERT INTO `groupinf` VALUES ('G','SUNDRY CREDITORS');
INSERT INTO `groupinf` VALUES ('F','OUTSTANDING LIABILITIES');
INSERT INTO `groupinf` VALUES ('E','ADVANCE TAKEN (CAPITAL)');
INSERT INTO `groupinf` VALUES ('D','LOAN REPAYMENT/REFUND');
INSERT INTO `groupinf` VALUES ('C','SECURED LOANS');
INSERT INTO `groupinf` VALUES ('B','DRAWINGS');
INSERT INTO `groupinf` VALUES ('A','CAPITAL ACCOUNTS');
CREATE TABLE `itemsinf` (
  `ITEMCODE` int(11) NOT NULL AUTO_INCREMENT,
  `ITEMNAME` varchar(140) DEFAULT '-',
  `HSN` varchar(8) DEFAULT '-',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `CATEGORY` varchar(30) DEFAULT '-',
  `BRAND` varchar(20) DEFAULT '-',
  `MODEL` varchar(40) DEFAULT '-',
  `SPEC` varchar(50) DEFAULT '-',
  `UNIT` varchar(6) DEFAULT 'Pc',
  `OPQTY` decimal(10,2) DEFAULT '0.00',
  `OPBALANCE` decimal(10,2) DEFAULT '0.00',
  `DISC` decimal(10,2) DEFAULT '0.00',
  `SALESDISC` decimal(10,2) DEFAULT '0.00',
  `MINSTOCK` decimal(10,2) DEFAULT '0.00',
  `DISCSTART` date DEFAULT '2000-01-01',
  `DISCEND` date DEFAULT '2000-01-01',
  `ISVERIFIED` int(3) DEFAULT '0',
  PRIMARY KEY (`ITEMCODE`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
CREATE TABLE `journal` (
  `JID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `JDATE` date DEFAULT '0000-00-00',
  `JNO` varchar(14) DEFAULT '-',
  `ENTFROM` varchar(10) DEFAULT '-',
  `AMOUNT` decimal(10,2) DEFAULT '0.00',
  `DRACCTCODE` varchar(8) DEFAULT '-',
  `CRACCTCODE` varchar(8) DEFAULT '-',
  `NARRATION` varchar(200) DEFAULT '-',
  `REFNO` varchar(15) DEFAULT '-',
  `REFDATE` date DEFAULT '0000-00-00',
  `LOCID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`JID`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;
CREATE TABLE `partytran` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `TRANDATE` date DEFAULT '2000-01-01',
  `ENTRYTYPE` varchar(30) DEFAULT '-',
  `DEBITAMT` double(10,2) DEFAULT '0.00',
  `CREDITAMT` double(10,2) DEFAULT '0.00',
  `PARTYCODE` varchar(10) DEFAULT '-',
  `REFNO` varchar(10) DEFAULT '-',
  `PMTMODE` varchar(30) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '1',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
CREATE TABLE `purchase` (
  `BILLNO` bigint(15) NOT NULL AUTO_INCREMENT,
  `BILLDATE` date DEFAULT '2000-01-01',
  `INVOICENO` varchar(30) DEFAULT NULL,
  `INVOICEDATE` date DEFAULT '2000-01-01',
  `SUPCODE` varchar(6) DEFAULT NULL,
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GST` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `GRDISC` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `PAIDAMT` decimal(10,2) DEFAULT '0.00',
  `PMTCODE` varchar(10) DEFAULT '-',
  `IGSTMODE` int(3) DEFAULT '0',
  `GSTIN` varchar(30) DEFAULT '-',
  `LOCID` int(3) DEFAULT '0',
  `WHID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`BILLNO`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
CREATE TABLE `purchasedet` (
  `PDId` bigint(15) NOT NULL AUTO_INCREMENT,
  `BILLNO` bigint(10) DEFAULT '0',
  `BILLDATE` date DEFAULT '2000-01-01',
  `ITEMCODE` int(11) DEFAULT '0',
  `QTY` decimal(10,2) DEFAULT '0.00',
  `FREE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `NPP` decimal(10,2) DEFAULT '0.00',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`PDId`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;
CREATE TABLE `purchasetmp` (
  `PTID` int(11) NOT NULL AUTO_INCREMENT,
  `INVOICENO` varchar(30) DEFAULT '-',
  `ITEMCODE` int(11) DEFAULT '0',
  `QTY` decimal(10,2) DEFAULT '0.00',
  `FREE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `NPP` decimal(10,2) DEFAULT '0.00',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`PTID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
CREATE TABLE `sales` (
  `BILLSL` bigint(16) unsigned NOT NULL AUTO_INCREMENT,
  `BILLNO` varchar(10) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  `BILLDATE` date DEFAULT '2000-01-01',
  `CUSTNAME` varchar(50) DEFAULT NULL,
  `MOBILE` varchar(15) DEFAULT NULL,
  `MATVAL` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `PAIDAMT` decimal(10,2) DEFAULT '0.00',
  `PARTYCODE` varchar(6) DEFAULT NULL,
  `GSTIN` varchar(30) DEFAULT '-',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`BILLSL`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
CREATE TABLE `salesdet` (
  `SDid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `BILLDATE` date DEFAULT '2000-01-01',
  `STKID` int(11) DEFAULT '0',
  `BILLNO` bigint(15) unsigned DEFAULT '0',
  `ITEMCODE` varchar(6) DEFAULT NULL,
  `QTY` decimal(10,2) DEFAULT '0.00',
  `UNIT` varchar(10) DEFAULT NULL,
  `MRP` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `DISCA` decimal(10,2) DEFAULT '0.00',
  `MATVAL` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `CGST` decimal(10,2) DEFAULT '0.00',
  `SGST` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `HSN` varchar(30) DEFAULT NULL,
  `WHID` int(3) DEFAULT '0',
  PRIMARY KEY (`SDid`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;
CREATE TABLE `salesdetbar` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `brCode` varchar(50) DEFAULT NULL,
  `SDID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `settings` (
  `ID` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `settings` VALUES (1);
CREATE TABLE `stock` (
  `STKID` int(11) NOT NULL AUTO_INCREMENT,
  `ITEMCODE` int(11) DEFAULT '0',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `QTY` int(10) DEFAULT '0',
  `LOTNO` varchar(50) DEFAULT '-',
  `NPP` double(10,2) DEFAULT '0.00',
  `WHID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`STKID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
CREATE TABLE `stockbar` (
  `BARCODE` varchar(50) NOT NULL DEFAULT '',
  `LOTNO` bigint(15) DEFAULT '0',
  `pdid` bigint(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `stocktransfer` (
  `STID` int(11) NOT NULL AUTO_INCREMENT,
  `CHALLANNO` varchar(30) DEFAULT '-',
  `CHALLANDATE` date DEFAULT '2000-01-01',
  `ITEMCODE` int(11) DEFAULT '0',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `TRANSFERQTY` int(3) DEFAULT '0',
  `RECEIPTQTY` int(3) DEFAULT '0',
  `LOC1` int(3) DEFAULT '0',
  `LOC2` int(3) DEFAULT '0',
  `STKID` int(11) DEFAULT '0',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`STID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `util` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `PREF1` varchar(30) DEFAULT '-',
  `PREF2` varchar(30) DEFAULT '-',
  `SUFF1` varchar(30) DEFAULT '-',
  `SUFF2` varchar(30) DEFAULT '-',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
INSERT INTO `util` VALUES (1,'pref1','pref2','suff1','suff2');

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
